package com.ejie.ab04b.dao.solicitud;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Pais;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.model.solicitud.SolicAperturas;
import com.ejie.ab04b.model.solicitud.SolicDatosNotificacion;
import com.ejie.ab04b.model.solicitud.SolicObra;
import com.ejie.ab04b.util.DaoUtils;

/**
 * SolicAperturasDaoImpl generated by UDA, 11-abr-2017 8:58:36.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class SolicAperturasDaoImpl implements SolicAperturasDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_SOLICITUD_056 IDSOLICITUD056, t1.TIPOSOL_056 TIPOSOL056, t1.ANOAPE_056 ANOAPE056, t1.NUMAPE_056 NUMAPE056, t1.FECPRE_056 FECPRE056, t1.NUEVA_056 NUEVA056, t1.TIPDOC_056 TIPDOC056, t1.NUMDOC_056 NUMDOC056,"
			+ " t1.NOMEMP_056 NOMEMP056, t1.PAISEMP_056 PAISEMP056, t1.PRVEMP_056 PRVEMP056, t1.MUNEMP_056 MUNEMP056, t1.DMUNEMP_056 DMUNEMP056, t1.DIREMP_056 DIREMP056, t1.CPOEMP_056 CPOEMP056, "
			+ "t1.TLFEMP_056 TLFEMP056, t1.CNAEEMP_056 CNAEEMP056, t1.ENTIAT_056 ENTIAT056, t1.TIPAPE_056 TIPAPE056, t1.NOMCTR_056 NOMCTR056, t1.PRVCTR_056 PRVCTR056, t1.MUNCTR_056 MUNCTR056, "
			+ "t1.LOCCTR_056 LOCCTR056, t1.DIRCTR_056 DIRCTR056, t1.CPOCTR_056 CPOCTR056, t1.TLFCTR_056 TLFCTR056, t1.FAXCTR_056 FAXCTR056, t1.EMAILCTR_056 EMAILCTR056, t1.CNAECTR_056 CNAECTR056,"
			+ " t1.PRVSS_056 PRVSS056, t1.NUMSS_056 NUMSS056, t1.DIGSS_056 DIGSS056, t1.FECINI_056 FECINI056, t1.TRBHOM_056 TRBHOM056, t1.TRBMUJ_056 TRBMUJ056, t1.TRBTOT_056 TRBTOT056, "
			+ "t1.CLASCTR_056 CLASCTR056, t1.DESCOBR_056 DESCOBR056, t1.SUPERF_056 SUPERF056, t1.PLANSEG_056 PLANSEG056, t1.CANALPLAN_056 CANALPLAN056, t1.PLANPRES_056 PLANPRES056, "
			+ "t1.PROYTEC_056 PROYTEC056, t1.DESCMAQ_056 DESCMAQ056, t1.POTEN_056 POTEN056, t1.INDANX_056 INDANX056, t1.APDOANX_056 APDOANX056, t1.DESTRAB_056 DESTRAB056, "
			+ "t1.INDOBRA_056 INDOBRA056, t1.CODOBRA_056 CODOBRA056, t1.CODCTR_056 CODCTR056, t1.LOTEMNT_056 LOTEMNT056, t1.ASGOSL_056 ASGOSL056, t1.CODENTIAT_056 CODENTIAT056, "
			+ "t1.CNAECTR93_056 CNAECTR93056, t1.CNAEEMP93_056 CNAEEMP93056, t1.MODPRE_056 MODPRE056, t1.NUMCNT_056 NUMCNT056, t1.EVALPRES_056 EVALPRES056, t1.CANALEVAL_056 CANALEVAL056, "
			+ "t1.REGEMP_056 REGEMP056, t1.NUMDOCREPRESENTANTE_056 NUMDOCREPRESENTANTE056, t1.TLFREPRESENTANTE_056 TLFREPRESENTANTE056, t1.TERAPE_056 TERAPE056, t1.FORPRE_056 FORPRE056, "
			+ "t1.FOLDER_ID_056 FOLDERID056, t1.COD_DATOS_NOTIF_056 CODDATOSNOTIF056, t1.ESTADO_SOLICITUD_056 ESTADOSOLICITUD056, t1.TIT_REPR_056 TITREPR056, t1.NOMREPRESENTANTE_056 NOMREPRESENTANTE056, "
			+ "t1.TIPDOCREPRESENTANTE_056 TIPDOCREPRESENTANTE056, t1.NUMREGISTRO_056 NUMREGISTRO056 FROM AB0456S01 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<SolicAperturas> rwMap = new RowMapper<SolicAperturas>() {
		public SolicAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			SolicAperturas solicitud = new SolicAperturas(
					resultSet.getLong("IDSOLICITUD056"),
					resultSet.getLong("TIPOSOL056"),
					resultSet.getString("ANOAPE056"),
					resultSet.getInt("NUMAPE056"),
					resultSet.getDate("FECPRE056"),
					resultSet.getString("NUEVA056"),
					resultSet.getString("TIPDOC056"),
					resultSet.getString("NUMDOC056"),
					resultSet.getString("NOMEMP056"), new Pais(
							resultSet.getString("PAISEMP056")), new Provincia(
							resultSet.getString("PRVEMP056")), new Municipio(
							resultSet.getString("MUNEMP056")),
					resultSet.getString("DMUNEMP056"),
					resultSet.getString("DIREMP056"),
					resultSet.getString("CPOEMP056"),
					resultSet.getString("TLFEMP056"),
					resultSet.getString("CNAEEMP056"),
					resultSet.getString("ENTIAT056"),
					resultSet.getString("TIPAPE056"),
					resultSet.getString("NOMCTR056"), new Provincia(
							resultSet.getString("PRVCTR056")), new Municipio(
							resultSet.getString("MUNCTR056")), new Localidad(
							resultSet.getString("LOCCTR056")),
					resultSet.getString("DIRCTR056"),
					resultSet.getString("CPOCTR056"),
					resultSet.getString("TLFCTR056"),
					resultSet.getString("FAXCTR056"),
					resultSet.getString("EMAILCTR056"),
					resultSet.getString("CNAECTR056"),
					resultSet.getString("PRVSS056"),
					resultSet.getString("NUMSS056"),
					resultSet.getString("DIGSS056"),
					resultSet.getDate("FECINI056"),
					resultSet.getLong("TRBHOM056"),
					resultSet.getLong("TRBMUJ056"),
					resultSet.getLong("TRBTOT056"),
					resultSet.getString("CLASCTR056"),
					resultSet.getString("DESCOBR056"),
					resultSet.getInt("SUPERF056"),
					resultSet.getString("PLANSEG056"),
					resultSet.getString("CANALPLAN056"),
					resultSet.getString("PLANPRES056"),
					resultSet.getString("PROYTEC056"),
					resultSet.getString("DESCMAQ056"),
					resultSet.getBigDecimal("POTEN056"),
					resultSet.getString("INDANX056"),
					resultSet.getString("APDOANX056"),
					resultSet.getString("DESTRAB056"),
					resultSet.getString("INDOBRA056"), null,
					resultSet.getInt("CODCTR056"),
					resultSet.getString("LOTEMNT056"),
					resultSet.getString("ASGOSL056"),
					resultSet.getString("CODENTIAT056"),
					resultSet.getString("CNAECTR93056"),
					resultSet.getString("CNAEEMP93056"),
					resultSet.getInt("MODPRE056"),
					resultSet.getLong("NUMCNT056"),
					resultSet.getString("EVALPRES056"),
					resultSet.getString("CANALEVAL056"),
					resultSet.getString("REGEMP056"),
					resultSet.getString("NUMDOCREPRESENTANTE056"),
					resultSet.getString("TLFREPRESENTANTE056"),
					resultSet.getString("TERAPE056"),
					resultSet.getString("FORPRE056"),
					resultSet.getString("FOLDERID056"),
					new SolicDatosNotificacion(resultSet
							.getInt("CODDATOSNOTIF056")),
					resultSet.getString("ESTADOSOLICITUD056"),
					resultSet.getString("TITREPR056"),
					resultSet.getString("TIPDOCREPRESENTANTE056"),
					resultSet.getString("NOMREPRESENTANTE056"),
					resultSet.getString("NUMREGISTRO056"));

			Long codObra = DaoUtils.getInstance().getLongNullable(resultSet,
					"CODOBRA056");
			if (codObra != null) {
				solicitud.setObra(new SolicObra(codObra));
			}

			if (solicitud.getRegemp056() != null) {
				String[] regemp = solicitud.getRegemp056().split("/");
				solicitud.setRegemp1(regemp[0]);
				solicitud.setRegemp2(regemp[1]);
				solicitud.setRegemp3(regemp[ConstantesNum.NUM_2]);
			}

			return solicitud;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource
	 *            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the SolicAperturas table.
	 * 
	 *  numRegSolicitud
	 *            String
	 *  SolicAperturas
	 *
	 * @param numRegSolicitud the num reg solicitud
	 * @return the solic aperturas
	 */
	@Transactional(readOnly = true)
	public SolicAperturas findSolicitud(String numRegSolicitud) {
		StringBuilder query = new StringBuilder(
				SolicAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.NUMREGISTRO_056 = ? ");

		List<SolicAperturas> solicaperturasList = this.jdbcTemplate.query(
				query.toString(), this.rwMap, numRegSolicitud);
		return (SolicAperturas) DataAccessUtils
				.uniqueResult(solicaperturasList);
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 *  solicitudes
	 *            Solicitudes
	 *  Solicitudes
	 *
	 * @param solicitudes the solicitudes
	 * @return the solic aperturas
	 */
	public SolicAperturas updateDatosApe(SolicAperturas solicitudes) {
		String query = "UPDATE AB0456S01 SET ANOAPE_056 = ?, NUMAPE_056= ?, TERAPE_056= ? WHERE ID_SOLICITUD_056 = ? ";
		this.jdbcTemplate.update(query, solicitudes.getAnoape056(),
				solicitudes.getNumape056(), solicitudes.getTerape056(),
				solicitudes.getIdSolicitud056());
		return solicitudes;
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 *  solicitudes
	 *            Solicitudes
	 *  Solicitudes
	 *
	 * @param solicitudes the solicitudes
	 * @return the solic aperturas
	 */
	public SolicAperturas updateEstado(SolicAperturas solicitudes) {
		String query = "UPDATE AB0456S01 SET ESTADO_SOLICITUD_056 = ? WHERE ID_SOLICITUD_056 = ? ";
		this.jdbcTemplate.update(query, solicitudes.getEstadoSolicitud056(),
				solicitudes.getIdSolicitud056());
		return solicitudes;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
